/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesListJson.java 1518 2013-10-03 09:02:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.ManagementMode;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Management mode list json action.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesListJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5032928580196001618L;

    protected ManagementModeService managementModeService;

    protected String filter;

    protected ResultList<ManagementMode> managementModes;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        ManagementModeFilter managementModeFilter = getGson().fromJson(filter, ManagementModeFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        managementModeFilter.setNavigationContext(navigationContext);
        managementModes = managementModeService.getFilteredManagementModes(managementModeFilter);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return managementModes;
    }

}
