/*
 * #%L
 * Agrosyst :: Web
 * $Id: ManagementModesEditJson.java 1565 2013-10-07 09:47:33Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/managementmodes/ManagementModesEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import java.util.List;
import java.util.Map;

import org.apache.struts2.convention.annotation.Action;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.DecisionRule;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Management mode edit json actions.
 * 
 * @author Eric Chatellier
 */
public class ManagementModesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3260095596557765111L;

    protected ManagementModeService managementModeService;

    /** Growing system id (for decision-rules-edit-cropping-plan-entries-json). */
    protected String growingSystemTopiaId;

    /** Type de bio agresseur (for management-edit-bio-agressors-json). */
    protected String bioAgressorType;

    protected Object jsonData;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public void setBioAgressorType(String bioAgressorType) {
        this.bioAgressorType = bioAgressorType;
    }

    /**
     * Récupération de la liste des cultures et des règles à la sélection d'un système de culture.
     * 
     * @return SUCCESS
     */
    @Action("management-modes-edit-growing-system-data-json")
    public String listCroppingPlanEntries() {
        List<CroppingPlanEntry> croppingPlanEntries = managementModeService.getGrowingSystemCroppingPlanEntries(growingSystemTopiaId);
        List<DecisionRule> decisionRules = managementModeService.getGrowingSystemDecisionRules(growingSystemTopiaId);
        Map<String, Object> result = Maps.newHashMap();
        result.put("croppingPlanEntries", croppingPlanEntries);
        result.put("decisionRules", decisionRules);
        jsonData = result;
        return SUCCESS;
    }

    /**
     * Recuperation de la liste des bio agresseurs filtrée par type.
     * 
     * @return SUCCESS
     */
    @Action("management-modes-edit-bio-agressors-json")
    public String listBioAgressors() {
        jsonData = managementModeService.getBioAgressor(bioAgressorType);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }
}
