package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsListJson.java 1381 2013-09-18 15:37:30Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GrowingSystemsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -5974287104680221588L;

    protected GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    protected String filter;

    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();
    protected Set<String> selectedDomains = Sets.newHashSet();
    protected Set<String> selectedGrowingPlans = Sets.newHashSet();

    protected ResultList<GrowingSystem> growingSystems;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public void setSelectedGrowingPlans(Set<String> selectedGrowingPlans) {
        this.selectedGrowingPlans = selectedGrowingPlans;
    }

    @Override
    public String execute() {
        GrowingSystemFilter growingSystemFilter = getGson().fromJson(filter, GrowingSystemFilter.class);
        NavigationContext navigationContext;
        if (selectedCampaigns.isEmpty() && selectedNetworks.isEmpty() && selectedDomains.isEmpty() && selectedGrowingPlans.isEmpty()) {
            navigationContext = getNavigationContext();
        } else {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
            navigationContext.setDomains(selectedDomains);
            navigationContext.setGrowingPlans(selectedGrowingPlans);
        }
        growingSystemFilter.setNavigationContext(navigationContext);
        growingSystems = growingSystemService.getFilteredGrowingSystems(growingSystemFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return growingSystems;
    }

}
