package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsList.java 813 2013-08-05 12:41:04Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class GrowingSystemsList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -8763014594787954150L;

    protected GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    /**
     * Result serialized in json.
     */
    protected ResultList<GrowingSystem> growingSystems;

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        GrowingSystemFilter filter = new GrowingSystemFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        growingSystems = growingSystemService.getFilteredGrowingSystems(filter);
        return SUCCESS;
    }

    public String getGrowingSystemsJson() {
        String result = getGson().toJson(growingSystems);
        return result;
    }

    public Map<Sector, String> getSectors() {
        return getEnumAsMap(Sector.values());
    }

}
