package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansList.java 928 2013-08-13 09:26:31Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Action d'affichage de la liste paginée des dispositifs.
 * 
 * @author Eric Chatellier
 */
public class GrowingPlansList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -430109839071419528L;

    /** Init growing plans. */
    protected ResultList<GrowingPlan> growingPlansResult;

    /** Domain list (for duplicate option). */
    protected List<Domain> domains;

    protected GrowingPlanService growingPlanService;
    
    protected DomainService domainService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        
        // get init growing plans
        GrowingPlanFilter growingPlanFilter = new GrowingPlanFilter();
        growingPlanFilter.setNavigationContext(navigationContext);
        growingPlanFilter.setPageSize(getConfig().getListResultsPerPage());
        growingPlansResult = growingPlanService.getFilteredGrowingPlans(growingPlanFilter);
        
        // get all active domains (duplicate action)
        DomainFilter domainFilter = new DomainFilter();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setActive(Boolean.TRUE);
        ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter);
        domains = domainListResult.getElements();

        return SUCCESS;
    }

    public ResultList<GrowingPlan> getGrowingPlansResult() {
        return growingPlansResult;
    }

    public List<Domain> getDomains() {
        return domains;
    }

    public Map<TypeDEPHY, String> getTypes() {
        return getEnumAsMap(TypeDEPHY.values());
    }

}
