package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsListJson.java 1381 2013-09-18 15:37:30Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Action de recuperation de la liste paginées des domaines (AJAX).
 * 
 * @author Eric Chatellier
 */
public class DomainsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = 8462808027355013164L;

    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();

    protected ResultList<Domain> domains;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public String execute() {
        DomainFilter domainFilter = getGson().fromJson(filter, DomainFilter.class);
        NavigationContext navigationContext;
        if (selectedCampaigns.isEmpty() && selectedNetworks.isEmpty()) {
            navigationContext = getNavigationContext();
        } else {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
        }
        domainFilter.setNavigationContext(navigationContext);

        domains = domainService.getFilteredDomains(domainFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return domains;
    }
}
