/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsEditJson.java 1660 2013-10-13 17:16:17Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.domains;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;

import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.api.services.referentiels.TypeMaterielFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Permet de gerer les methode json pour l'edition d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsEditJson extends AbstractJsonAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4134613183262825235L;

    protected ReferentielService referentielService;

    protected DomainService domainService;

    /** Filter for materiel* actions. */
    protected String filter;

    /** Region for RefSolArvalis actions. */
    protected int regionCode;

    /** otex18code form edit domain otex code. */
    protected Integer otex18code;

    /** Domain name (to check existance). */
    protected String domainName;

    protected Object data;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public void prepare() throws Exception {
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setRegionCode(int regionCode) {
        this.regionCode = regionCode;
    }

    public void setOtex18code(Integer otex18code) {
        this.otex18code = otex18code;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Action("domain-edit-materiel-type2-json")
    public String listMaterielType2() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel2List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type3-json")
    public String listMaterielType3() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel3List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type4-json")
    public String listMaterielType4() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel4List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-unite-json")
    public String listMaterielUnite() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getMaterielUniteMap(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-all-json")
    public String listMaterielAll() {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = new ArrayList<Object>(4);
        ((List<Object>)data).add(referentielService.getTypeMateriel2List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getTypeMateriel3List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getTypeMateriel4List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getMaterielUniteMap(typeMaterielFilter));
        return SUCCESS;
    }

    @Action("domain-edit-sol-arvalis-list-json")
    public String listSolArvalis() {
        data = referentielService.getSolArvalis(regionCode);
        return SUCCESS;
    }

    @Action("get-ref-otex-json")
    public String listRefOtex70() {
        data = referentielService.findAllActiveCodeOtex70ByOtex18code(otex18code);
        return SUCCESS;
    }

    @Action("check-domain-name-json")
    public String checkDomainName() {
        data = domainService.checkDomainExistence(domainName);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return data;
    }
}
