package fr.inra.agrosyst.web.actions.commons;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ShowGrowingSystemAndNetworkGraphRaw.java 1914 2013-10-28 16:35:19Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/commons/ShowGrowingSystemAndNetworkGraphRaw.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Set;

import fr.inra.agrosyst.api.services.network.NetworkGraph;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class ShowGrowingSystemAndNetworkGraphRaw extends AbstractAgrosystAction {

    private static final long serialVersionUID = 235930146604038026L;

    protected NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected Set<String> parentNetworkIds;
    protected String growingSystemName;

    public void setParentNetworkIds(Set<String> parentNetworkIds) {
        this.parentNetworkIds = parentNetworkIds;
    }

    public void setGrowingSystemName(String growingSystemName) {
        this.growingSystemName = growingSystemName;
    }

    protected NetworkGraph networkGraph;

    @Override
    public String execute() throws Exception {
        if (parentNetworkIds != null) {
            networkGraph = networkService.buildGrowingSystemAndNetworkGraph(growingSystemName, parentNetworkIds);
        }
        return SUCCESS;
    }

    public NetworkGraph getNetworkGraph() {
        return networkGraph;
    }
}
