package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: SystemTraceability.java 1850 2013-10-23 08:02:01Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/SystemTraceability.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.api.services.users.UserService;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class SystemTraceability extends AbstractAdminAction {


    protected DomainService domainService;

    protected GrowingSystemService growingSystemService;

    protected GrowingPlanService growingPlanService;

    protected NetworkService networkService;

    protected UserService userService;

    protected Long domainCount;

    protected Long growingSystemCount;

    protected Long growingPlanCount;

    protected Long networkCount;

    protected Long userCount;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public String execute() throws Exception {
        checkIsAdmin();
        domainCount = domainService.getDomainsCount();
        growingSystemCount = growingSystemService.getGrowingSystemsCount();
        growingPlanCount = growingPlanService.getGrowingPlansCount();
        networkCount = networkService.getNetworksCount();
        userCount = userService.getUsersCount();
        return SUCCESS;
    }

    public Long getDomainCount() {
        return domainCount;
    }

    public Long getGrowingSystemCount() {
        return growingSystemCount;
    }

    public Long getGrowingPlanCount() {
        return growingPlanCount;
    }

    public Long getNetworkCount() {
        return networkCount;
    }

    public Long getUserCount() {
        return userCount;
    }
}
