package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunExport.java 1856 2013-10-24 08:05:42Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunExport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.referentiels.RefActionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefAdventices;
import fr.inra.agrosyst.api.entities.referentiels.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.entities.referentiels.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiTypesEffluents;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefNuisiblesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefOTEX;
import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefSolCaracteristiquesIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referentiels.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referentiels.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefUnitesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referentiels.RefVarietePlantGrape;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referentiels.ExportService;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RunExport extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(RunExport.class);

    private static final long serialVersionUID = -5821886179843474360L;

    protected ExportService exportService;

    public void setImportService(ExportService exportService) {
        this.exportService = exportService;
    }

    protected String genericClassName;
    protected List<String> entityIds;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "text/csv",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        checkIsAdmin();
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            Class<?> klass = Class.forName(genericClassName);
            
            if (RefSolArvalis.class.equals(klass)) {
                inputStream = exportService.exportSolArvalisCSV(entityIds);
            }

            /*if (RefLocation.class.equals(klass)) {
                can't export this one
            }*/

            if (RefMaterielTraction.class.equals(klass)) {
                inputStream = exportService.exportMaterielTracteursCSV(entityIds);
            }

            if (RefMaterielIrrigation.class.equals(klass)) {
                inputStream = exportService.exportMaterielIrrigationCSV(entityIds);
            }

            if (RefMaterielAutomoteur.class.equals(klass)) {
                inputStream = exportService.exportMaterielAutomoteursCSV(entityIds);
            }

            if (RefMaterielOutil.class.equals(klass)) {
                inputStream = exportService.exportMaterielOutilsCSV(entityIds);
            }

            if (RefLegalStatus.class.equals(klass)) {
                inputStream = exportService.exportLegalStatusCSV(entityIds);
            }

            if (RefEspece.class.equals(klass)) {
                inputStream = exportService.exportEspeces(entityIds);
            }

            if (RefVarieteGeves.class.equals(klass)) {
                inputStream = exportService.exportVarietesGeves(entityIds);
            }

            if (RefEspeceToVariete.class.equals(klass)) {
                inputStream = exportService.exportEspecesToVarietes(entityIds);
            }

            if (RefOTEX.class.equals(klass)) {
                inputStream = exportService.exportOtexCSV(entityIds);
            }

            if (RefClonePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportClonesPlantGrape(entityIds);
            }

            if (RefVarietePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportVarietesPlantGrape(entityIds);
            }

            if (RefOrientationEDI.class.equals(klass)) {
                inputStream = exportService.exportOrientationEdiCSV(entityIds);
            }

            if (RefSolTextureGeppa.class.equals(klass)) {
                inputStream = exportService.exportSolTextureGeppa(entityIds);
            }

            if (RefParcelleZonageEDI.class.equals(klass)) {
                inputStream = exportService.exportZonageParcelleEdi(entityIds);
            }

            if (RefSolProfondeurIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolProfondeurIndigo(entityIds);
            }

            if (RefSolCaracteristiquesIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolCarateristiquesIndigo(entityIds);
            }
            
            if (RefAdventices.class.equals(klass)) {
                inputStream = exportService.exportAdventices(entityIds);
            }
            
            if (RefNuisiblesEDI.class.equals(klass)) {
                inputStream = exportService.exportNuisiblesEDI(entityIds);
            }
            
            if (RefFertiEngraisorg.class.equals(klass)) {
                inputStream = exportService.exportFertiEngraisOrg(entityIds);
            }
            
            if (RefFertiMinUNIFA.class.equals(klass)) {
                inputStream = exportService.exportFertiMinUNIFA(entityIds);
            }
            
            if (RefFertiTypesEffluents.class.equals(klass)) {
                inputStream = exportService.exportFertiMinUNIFA(entityIds);
            }
            
            if (RefTypeTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportTypeTravailEdiCSV(entityIds);
            }
            
            if (RefActionAgrosystTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportActionAgrosystTravailEdiCSV(entityIds);
            }
            
            if (RefStadeEDI.class.equals(klass)) {
                inputStream = exportService.exportStadesEdiCSV(entityIds);
            }
            
            if (RefUnitesEDI.class.equals(klass)) {
                inputStream = exportService.exportUnitesEdi(entityIds);
            }
            
            if (RefStationMeteo.class.equals(klass)) {
                inputStream = exportService.exportStationMeteo(entityIds);
            }

        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate csv", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "export" + StringUtils.substringAfterLast(genericClassName, ".") + ".csv";
        return filename;
    }
}
