package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractAdminAction.java 1856 2013-10-24 08:05:42Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/AbstractAdminAction.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.ActionType;
import fr.inra.agrosyst.api.entities.CapacityUnit;
import fr.inra.agrosyst.api.entities.CategoryObjective;
import fr.inra.agrosyst.api.entities.CategoryStrategy;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.FertilizerQuantityUnit;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.InterventionType;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.SectionType;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.SeedType;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.StrategyType;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.UnitPlantSeeds;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.YealdCategory;
import fr.inra.agrosyst.api.entities.YealdUnit;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.referentiels.RefActionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefAdventices;
import fr.inra.agrosyst.api.entities.referentiels.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.entities.referentiels.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiEngraisorg;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referentiels.RefFertiTypesEffluents;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefNuisiblesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefOTEX;
import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefSolCaracteristiquesIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referentiels.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referentiels.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referentiels.RefTypeTravailEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefUnitesEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referentiels.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public abstract class AbstractAdminAction extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -5817371954801847984L;

    protected static final Class[] AUTHORITY_BASE_CLASSES = new Class[]{
            ActionType.class,
            CapacityUnit.class,
            CategoryObjective.class,
            CategoryStrategy.class,
            CropCyclePhaseType.class,
            CroppingEntryType.class,
            DomainType.class,
            FertilizerQuantityUnit.class,
            FrostProtectionType.class,
            HosesPositionning.class,
            InterventionType.class,
            IrrigationSystemType.class,
            ManagementModeCategory.class,
            MaxSlope.class,
            OrchardFrutalForm.class,
            PollinatorSpreadMode.class,
            PompEngineType.class,
            PracticedSystemSource.class,
            SectionType.class,
            Sector.class,
            SeedType.class,
            SolWaterPh.class,
            StrategyType.class,
            TypeDEPHY.class,
            UnitPlantSeeds.class,
            VineFrutalForm.class,
            WaterFlowDistance.class,
            WeedType.class,
            YealdCategory.class,
            YealdUnit.class,
            Zoning.class,
            ZoneType.class
    };

    protected static final Class[] REFERENTIAL_BASE_CLASSES = new Class[]{
            RefFertiMinUNIFA.class,
            RefLocation.class,
            RefSolArvalis.class,
            RefLegalStatus.class,
            RefMaterielAutomoteur.class,
            RefMaterielIrrigation.class,
            RefMaterielTraction.class,
            RefMaterielOutil.class,
            RefEspece.class,
            RefVarieteGeves.class,
            RefVarietePlantGrape.class,
            RefClonePlantGrape.class,
            RefEspeceToVariete.class,
            RefOrientationEDI.class,
            RefOTEX.class,
            RefTypeTravailEDI.class,
            RefActionAgrosystTravailEDI.class,
            RefStadeEDI.class,
            RefParcelleZonageEDI.class,
            RefSolProfondeurIndigo.class,
            RefSolTextureGeppa.class,
            RefSolCaracteristiquesIndigo.class,
            RefStationMeteo.class,
            RefUnitesEDI.class,
            RefAdventices.class,
            RefNuisiblesEDI.class,
            RefFertiTypesEffluents.class,
            RefFertiEngraisorg.class
    };
    protected static final Function<Class,String> GET_CLASS_NAME = new Function<Class, String>() {
        @Override
        public String apply(Class input) {
            return input.getName();
        }
    };

    protected static List<String> authorityBaseClassNames;
    protected static List<String> referentialBaseClassNames;

    protected Map<String, Long> referentialClasses;

    protected Map<String, Long> authorityClasses;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    protected void checkIsAdmin() {
        authorizationService.checkIsAdmin();
    }

    protected void sortFromI18n(Class<?>... classes) {
        Arrays.sort(classes, new Comparator<Class<?>>() {
            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                String className1 = o1.getName();
                String className2 = o2.getName();
                String text1 = getText(className1, className1);
                String text2 = getText(className2, className2);
                return text1.compareTo(text2);
            }
        });
    }

    @Override
    public void prepare() throws Exception {
        if (referentialBaseClassNames == null) {
            sortFromI18n(REFERENTIAL_BASE_CLASSES);
            referentialBaseClassNames = Lists.newArrayList();
            Iterables.addAll(referentialBaseClassNames, Iterables.transform(Arrays.asList(REFERENTIAL_BASE_CLASSES), GET_CLASS_NAME));
        }
        if (authorityBaseClassNames == null) {
            sortFromI18n(AUTHORITY_BASE_CLASSES);
            authorityBaseClassNames = Lists.newArrayList();
            Iterables.addAll(authorityBaseClassNames, Iterables.transform(Arrays.asList(AUTHORITY_BASE_CLASSES), GET_CLASS_NAME));
        }

        referentialClasses = service.countEntitiesFromString(referentialBaseClassNames);
        authorityClasses = service.countEntitiesFromString(authorityBaseClassNames);

    }

    public Map<String, Long> getReferentialClasses() {
        return referentialClasses;
    }

    public Map<String, Long> getAuthorityClasses() {
        return authorityClasses;
    }

}
