package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystJsonResultSupport.java 1684 2013-10-16 11:47:36Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AgrosystJsonResultSupport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.IOException;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.StrutsResultSupport;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.opensymphony.xwork2.ActionInvocation;

import fr.inra.agrosyst.commons.gson.EmptyAgrosystGsonSupplier;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystJsonResultSupport extends StrutsResultSupport {

    private static final long serialVersionUID = 4604320651695670319L;

    private static final Log log = LogFactory.getLog(AgrosystJsonResultSupport.class);

    protected Gson gson;

    public Gson getGson() {
        if (gson == null) {
            // TODO AThimel 16/10/13 It would be better to use a real GsonSupplier
            gson = new EmptyAgrosystGsonSupplier().get();
        }
        return gson;
    }

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        Object jsonData = invocation.getStack().findValue("jsonData");

        if (jsonData == null && log.isWarnEnabled()) {
            log.warn("Unable to get 'jsonData'. Please check that your getJsonData() method is public.");
        }

        String json = getGson().toJson(jsonData);

        // Find the Response in context
        HttpServletResponse servletResponse = (HttpServletResponse) invocation.getInvocationContext().get(HTTP_RESPONSE);

        servletResponse.setCharacterEncoding(Charsets.UTF_8.name());
        servletResponse.setContentType("application/json");

        try {
            ServletOutputStream outputStream = servletResponse.getOutputStream();
            byte[] jsonBytes = json.getBytes(Charsets.UTF_8); // On transforme en bytes pour assurer l'encodage
            outputStream.write(jsonBytes);
        } catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("Unable to write JSON output into Servlet Response");
            }
        }

    }

}
