/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotificationLink.java 1725 2013-10-18 17:17:36Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotificationLink.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import java.util.Map;

public class AgrosystWebNotificationLink {

    protected String label;

    protected String action;

    protected String namespace;

    protected Map<String, String> args;

    public AgrosystWebNotificationLink(String label, String namespace, String action, Map<String, String> args) {
        this.label = label;
        this.action = action;
        this.namespace = namespace;
        this.args = args;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getArgs() {
        return args;
    }

    public void setArgs(Map<String, String> args) {
        this.args = args;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AgrosystWebNotificationLink that = (AgrosystWebNotificationLink) o;

        if (action != null ? !action.equals(that.action) : that.action != null) return false;
        if (args != null ? !args.equals(that.args) : that.args != null) return false;
        if (label != null ? !label.equals(that.label) : that.label != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) : that.namespace != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = label != null ? label.hashCode() : 0;
        result = 31 * result + (action != null ? action.hashCode() : 0);
        result = 31 * result + (namespace != null ? namespace.hashCode() : 0);
        result = 31 * result + (args != null ? args.hashCode() : 0);
        return result;
    }

}
