/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebConfig.java 1674 2013-10-15 15:09:42Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebConfig.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

/**
 * Web module configuration.
 *
 * @author Eric Chatellier
 */
public class AgrosystWebConfig {

    /**
     * Configuration filename.
     */
    protected static final String AGROSYST_CONF_FILENAME = "agrosyst.properties";

    public static final String NAVIGATION_CONTEXT_COOKIE_NAME = "nav.context";

    /**
     * Delegate application config.
     */
    protected ApplicationConfig config;

    public AgrosystWebConfig() {
        config = new ApplicationConfig();
        config.loadDefaultOptions(WebConfigOption.values());
    }

    public void parse(String... args) {
        try {
            config.parse(args);
        } catch (ArgumentsParserException ex) {
            throw new RuntimeException("Can't read configuration", ex);
        }
    }

    public String getApplicationVersion() {
        return config.getOption(WebConfigOption.APPLICATION_VERSION.key);
    }

    public int getListResultsPerPage() {
        return config.getOptionAsInt(WebConfigOption.LIST_RESULTS_PER_PAGE.key);
    }

    public String getTileServerUrl() {
        return config.getOption(WebConfigOption.TILE_SERVER_URL.key);
    }

    public boolean isServicesRemoteEnabled() {
        return config.getOptionAsBoolean(WebConfigOption.SERVICES_REMOTE_ENABLED.getKey());
    }

    public String getServicesRemoteBaseUrl() {
        String result = config.getOption(WebConfigOption.SERVICES_REMOTE_BASE_URL.getKey());
        if (result != null && !result.endsWith("/")) {
            result += "/";
        }
        return result;
    }


    static enum WebConfigOption implements ConfigOptionDef {

        FILENAME(ApplicationConfig.CONFIG_FILE_NAME, AGROSYST_CONF_FILENAME),

        APPLICATION_VERSION("agrosyst.web.application.version", null),

        LIST_RESULTS_PER_PAGE("agrosyst.web.list.results.per.page", "10"),

        /**
         * Non default OSM tile server provider.
         */
        TILE_SERVER_URL("agrosyst.web.tile.server.url", null),

        SERVICES_REMOTE_ENABLED("agrosyst.web.services.remote.enabled", "false"),

        SERVICES_REMOTE_BASE_URL("agrosyst.web.services.remote.baseUrl", null);

        private String key;
        private String defaultValue;

        private WebConfigOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public void setDefaultValue(String defaultValue) {

        }

        @Override
        public void setTransient(boolean isTransient) {

        }

        @Override
        public void setFinal(boolean isFinal) {

        }
    }
}
