package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationListener.java 1674 2013-10-15 15:09:42Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationListener.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Method;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebApplicationListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationListener.class);

    protected AgrosystWebApplicationContext context;

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("Initializing Agrosyst Web Module");
        }

//        if (log.isInfoEnabled()) {
//            log.info("Initializing I18n...");
//        }
//
//        I18nInitializer initializer = new DefaultI18nInitializer("agrosyst-web");
//        initializer.setMissingKeyReturnNull(true);
//        I18n.init(initializer, Locale.FRANCE);


        context = new AgrosystWebApplicationContext();
        context.init();

        sce.getServletContext().setAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER, context);

        checkForDemoDatas();
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Destroy Agrosyst Web Module");
        }

        context.close();
    }

    protected void checkForDemoDatas() {
        if (!context.getWebConfig().isServicesRemoteEnabled()) {
            try {
                Class<?> demoDataClass = Class.forName("fr.inra.agrosyst.services.demo.DemoDatas");
                Method method = demoDataClass.getMethod("onInit");
                method.invoke(null);
            } catch (Exception eee) {
                throw new AgrosystTechnicalException("Unable to initialize data", eee);
            }
        }
    }

}
