package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationContext.java 1666 2013-10-14 13:14:22Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.6.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationContext.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebApplicationContext {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationContext.class);

    public static final String APPLICATION_CONTEXT_PARAMETER = AgrosystWebApplicationContext.class.getName();

    protected AgrosystWebConfig webConfig;

    protected Object serviceConfig;

    public void init() {

        webConfig = new AgrosystWebConfig();
        webConfig.parse();

        try {
            Class<?> defaultConfigSupplierClass = Class.forName("fr.inra.agrosyst.services.DefaultConfigurationSupplier");
            serviceConfig = defaultConfigSupplierClass.getMethod("getDefaultConfiguration").invoke(null);
        } catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occurred", e);
            }
        } catch (InvocationTargetException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occurred", e);
            }
        } catch (NoSuchMethodException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occurred", e);
            }
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occurred", e);
            }
        }
    }

    public AgrosystWebConfig getWebConfig() {
        return webConfig;
    }

    public Object getServiceConfig() {
        return serviceConfig;
    }

    public void close() {
        // TODO AThimel 11/10/13 Nothing to do
    }

}
