package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersList.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * User list action.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class UsersList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4895779258937582288L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    /**
     * User result list serialized as JSON.
     */
    protected String usersJson;

    @Override
    public String execute() throws Exception {
        UserFilter userFilter = new UserFilter();
        userFilter.setPageSize(getConfig().getListResultsPerPage());
        ResultList<UserDto> users = userService.getFilteredUsers(userFilter);
        usersJson = getGson().toJson(users);
        return SUCCESS;
    }

    public String getUsersJson() {
        return usersJson;
    }

}
