package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSeasonalCropCycleEdit.java 1157 2013-09-05 13:52:00Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSeasonalCropCycleEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.CropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleService;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class PracticedSeasonalCropCycleEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = 8402963127354686581L;

    protected static final Predicate<CropCycleModelDto> IS_INTERMEDIATE = new Predicate<CropCycleModelDto>() {
        public boolean apply(CropCycleModelDto input) {
            return input.isIntermediate();
        }
    };

    protected static final Predicate<CropCycleModelDto> IS_NOT_INTERMEDIATE = Predicates.not(IS_INTERMEDIATE);

    protected PracticedCropCycleService practicedCropCycleService;
    protected PracticedSystemService practicedSystemService;

    protected String cycleId;

    protected String practicedSystemId;

    protected PracticedSeasonalCropCycle cycle;

    protected List<PracticedSystem> availablePracticedSystems;

    /** Les cultures principales. */
    protected List<CropCycleModelDto> model;

    /** Les cultures intermédiaires. */
    protected List<CropCycleModelDto> modelIntermediate;

    protected List<CropCycleNodeDto> nodes;

    protected List<CropCycleConnectionDto> connections;

    protected Map<String, List<CroppingPlanSpeciesDto>> codeToSpecies;

    public void setPracticedCropCycleService(PracticedCropCycleService practicedCropCycleService) {
        this.practicedCropCycleService = practicedCropCycleService;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setCycleId(String cycleId) {
        this.cycleId = cycleId;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    public void setNodesJson(String nodesJson) {
        Type type = new TypeToken<List<CropCycleNodeDto>>() {
        }.getType();
        this.nodes = getGson().fromJson(nodesJson, type);
    }

    public void setConnectionsJson(String connectionsJson) {
        Type type = new TypeToken<List<CropCycleConnectionDto>>() {
        }.getType();
        this.connections = getGson().fromJson(connectionsJson, type);
    }

    @Override
    public void prepare() throws Exception {
        // This will create a new instance if there is no cycle found with the given cycleId
        cycle = practicedCropCycleService.getPracticedSeasonalCropCycle(cycleId);
    }

    @Override
    protected void initForInput() {
        if (cycle.isPersisted()) {
            availablePracticedSystems = ImmutableList.of(cycle.getPracticedSystem());
        } else {
            availablePracticedSystems = practicedCropCycleService.getAvailablePracticedSystems(getNavigationContext());
        }
    }

    @Override
    public String input() throws Exception {
        initForInput();

        this.codeToSpecies = Maps.newHashMap();
        this.nodes = Lists.newArrayList();

        if (cycle.isPersisted()) {
            practicedSystemId = cycle.getPracticedSystem().getTopiaId();

            Map<CropCycleNodeDto,List<CroppingPlanSpeciesDto>> nodesToSpecies = practicedCropCycleService.getNodes(cycle.getTopiaId());
            for (Map.Entry<CropCycleNodeDto, List<CroppingPlanSpeciesDto>> entry : nodesToSpecies.entrySet()) {
                CropCycleNodeDto cycleNodeDto = entry.getKey();
                this.codeToSpecies.put(cycleNodeDto.getCroppingPlanEntryCode(), entry.getValue());
                this.nodes.add(cycleNodeDto);
            }
            this.connections = practicedCropCycleService.getConnections(cycle.getTopiaId());
        } else {
            this.connections = Lists.newArrayList();
        }

        /*if (!Strings.isNullOrEmpty(practicedSystemId)) {
            // recuperation de toutes les cultures
            Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> modelToSpecies = practicedSystemService.getCropCycleModel(practicedSystemId);
            for (Map.Entry<CropCycleModelDto, List<CroppingPlanSpeciesDto>> entry : modelToSpecies.entrySet()) {
                this.codeToSpecies.put(entry.getKey().getCroppingPlanEntryCode(), entry.getValue());
            }
            Set<CropCycleModelDto> model = modelToSpecies.keySet();

            // definition de la liste de culture principale
            Iterable<CropCycleModelDto> modelMain = Iterables.filter(model, IS_NOT_INTERMEDIATE);
            this.model = Lists.newArrayList(modelMain);

            // définition de la liste de culture intermédiaire
            Iterable<CropCycleModelDto> modelIntermediate = Iterables.filter(model, IS_INTERMEDIATE);
            this.modelIntermediate = Lists.newArrayList(modelIntermediate);
        }*/

        if (connections != null && modelIntermediate != null) {
            for (CropCycleConnectionDto connection : connections) {
                final String expectedCode = connection.getIntermediateCroppingPlanEntryCode();
                if (!Strings.isNullOrEmpty(expectedCode)) {
                    Optional<CropCycleModelDto> optional = Iterables.tryFind(modelIntermediate, new Predicate<CropCycleModelDto>() {
                        @Override
                        public boolean apply(CropCycleModelDto input) {
                            return expectedCode.equals(input.getCroppingPlanEntryCode());
                        }
                    });
                    if (optional.isPresent()) {
                        connection.setLabel(optional.get().getLabel());
                    }
                }
            }
        }

        return INPUT;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "practiced-crop-cycles-list"})})
    public String execute() throws Exception {

        practicedCropCycleService.createOrUpdatePracticedSeasonalCropCycle(cycle, practicedSystemId, nodes, connections);

        return SUCCESS;
    }

    public PracticedSeasonalCropCycle getCycle() {
        return cycle;
    }

    public String getPracticedSystemId() {
        return practicedSystemId;
    }

    public List<PracticedSystem> getAvailablePracticedSystems() {
        return availablePracticedSystems;
    }

    public List<CropCycleModelDto> getModel() {
        return model;
    }

    public List<CropCycleModelDto> getModelIntermediate() {
        return modelIntermediate;
    }

    public List<CropCycleNodeDto> getNodes() {
        return nodes;
    }

    public List<CropCycleConnectionDto> getConnections() {
        return connections;
    }

    public Map<String, List<CroppingPlanSpeciesDto>> getCodeToSpecies() {
        return codeToSpecies;
    }
}
