package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadToolsCouplingsJson.java 1082 2013-08-29 16:46:39Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadToolsCouplingsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class LoadToolsCouplingsJson extends AbstractJsonAction{
    

    private static final long serialVersionUID = 4068111016024230102L;
    
    protected PracticedSystemService practicedSystemService;
    
    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }
    
    protected String growingSystemId;
    
    protected List<ToolsCouplingDto> toolsCouplingsDtos;

    @Override
    public String execute() throws Exception {
        toolsCouplingsDtos = practicedSystemService.getToolsCouplingModel(growingSystemId);
        return SUCCESS;
    }
    
    @Override
    public Object getJsonData() {
        return toolsCouplingsDtos;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

}
