package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadRefActionAgrosystTravailEdisJson.java 1176 2013-09-06 09:26:03Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadRefActionAgrosystTravailEdisJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.ActionType;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

import java.util.List;
import fr.inra.agrosyst.api.entities.referentiels.RefActionAgrosystTravailEDI;

public class LoadRefActionAgrosystTravailEdisJson extends AbstractJsonAction {

    protected fr.inra.agrosyst.api.entities.ActionType actionType;

    protected List<RefActionAgrosystTravailEDI> actionAgrosystTravailEDIs;

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public String execute() {
        actionAgrosystTravailEDIs = referentielService.getRefActionAgrosystTravailEDIs(actionType);
        return SUCCESS;
    }
    @Override
    public Object getJsonData() {
        return actionAgrosystTravailEDIs;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }
}
