package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadPerennialCroppingPlanSpeciesJson.java 1155 2013-09-05 13:26:33Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadPerennialCroppingPlanSpeciesJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.practiced.CropCyclePerennialSpeciesDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class LoadPerennialCroppingPlanSpeciesJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4680946995049096766L;

    protected PracticedCropCycleService practicedCropCycleService;
    
    protected String croppingPlanEntryCode;
    
    protected String cycleId;

    protected String growingSystemId;

    protected String campaigns;

    protected List<CropCyclePerennialSpeciesDto> cropCyclePerennialSpeciesDtos;
    
    public void setPracticedCropCycleService(PracticedCropCycleService practicedCropCycleService) {
        this.practicedCropCycleService = practicedCropCycleService;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    @Override
    public String execute() throws Exception {
        if (!Strings.isNullOrEmpty(croppingPlanEntryCode)) {
            cropCyclePerennialSpeciesDtos = practicedCropCycleService.getCropCyclePerennialSpecies(croppingPlanEntryCode, cycleId, growingSystemId, campaigns);
        }
        return SUCCESS;
    }

    public void setCroppingPlanEntryCode(String croppingPlanEntryCode) {
        this.croppingPlanEntryCode = croppingPlanEntryCode;
    }

    @Override
    public Object getJsonData() {
        return cropCyclePerennialSpeciesDtos;
    }

    public void setCycleId(String cycleId) {
        this.cycleId = cycleId;
    }
    
}
