package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadGrowingSystemCropsJson.java 1189 2013-09-06 15:46:56Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadGrowingSystemCropsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.struts2.convention.annotation.Action;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlans;
import fr.inra.agrosyst.api.services.practiced.CropCycleModelDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class LoadGrowingSystemCropsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4680946995049096766L;

    protected static final Predicate<CroppingPlanEntryDto> IS_INTERMEDIATE = new Predicate<CroppingPlanEntryDto>() {

        @Override
        public boolean apply(CroppingPlanEntryDto croppingPlanEntryDto) {
            return croppingPlanEntryDto.isIntermediate();
        }
    };

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    protected String growingSystemId;

    protected String campaigns;

    protected Object data;

    @Override
    public String execute() throws Exception {
        List<CropCycleModelDto> croppingPlanEntryDtos = practicedSystemService.getCropCycleModel(growingSystemId, campaigns, false);
        data = croppingPlanEntryDtos;
        return SUCCESS;
    }


    @Action("load-seasonal-cropping-json")
    public String execute2() throws Exception {
        Map<String, Object> map = Maps.newHashMap();
        
        Map<String, List<CroppingPlanSpeciesDto>> growingSystemsCodeToSpecies = Maps.newHashMap();
        // recuperation de toutes les cultures
        Map<CropCycleModelDto, List<CroppingPlanSpeciesDto>> modelToSpecies =
                practicedSystemService.getCropCycleModelMap(
                        growingSystemId, campaigns, true);
        for (Map.Entry<CropCycleModelDto, List<CroppingPlanSpeciesDto>> entry : modelToSpecies.entrySet()) {
            growingSystemsCodeToSpecies.put(entry.getKey().getCroppingPlanEntryCode(), entry.getValue());
        }
        Set<CropCycleModelDto> model = modelToSpecies.keySet();
        
        // definition de la liste de culture principale
        Iterable<CropCycleModelDto> modelMain = Iterables.filter(model, CroppingPlans.IS_NOT_INTERMEDIATE);
        map.put("seasonalGraphMainCrops", Lists.newArrayList(modelMain));

        // définition de la liste de culture intermédiaire
        Iterable<CropCycleModelDto> modelIntermediate = Iterables.filter(model, CroppingPlans.IS_INTERMEDIATE);
        map.put("seasonalGraphMainIntermediateCrops", Lists.newArrayList(modelIntermediate));
        
        map.put("growingSystemsCodeToSpecies", growingSystemsCodeToSpecies);
        
        data = map;
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return data;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

}
