package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsUnactivate.java 1026 2013-08-27 07:52:36Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class PlotsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -2564747399236374335L;

    protected PlotService plotService;

    protected List<String> plotIds;

    protected boolean activate;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }
    
    public void setPlotIds(List<String> plotIds) {
        this.plotIds = plotIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "plots-list" }) })
    public String execute() throws Exception {
        plotService.unactivatePlots(plotIds, activate);
        return SUCCESS;
    }
}
