package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsListJson.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.plot.PlotFilter;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class PlotsListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -5045697371859641721L;

    protected PlotService plotService;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    protected String filter;
    
    protected ResultList<Plot> plots;
    
    public void setFilter(String filter) {
        this.filter = filter;
    }
    
    @Override
    public String execute() {
        PlotFilter plotFilter = getGson().fromJson(filter, PlotFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        plotFilter.setNavigationContext(navigationContext);
        plots = plotService.getFilteredPlots(plotFilter);
        
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return plots;
    }
}
