package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotGrowingSystemsJson.java 971 2013-08-21 11:29:57Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotGrowingSystemsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 */
public class PlotGrowingSystemsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 760189523848814956L;

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    protected GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    protected String domainTopiaId;

    protected Map<String, Object> data = Maps.newHashMap();

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    @Override
    public String execute() throws Exception {
        Domain domain = domainService.getDomain(domainTopiaId);

        List<GrowingSystem> growingSystems = growingSystemService.findAllActiveByDomain(domain);
        data.put("growingSystems", growingSystems);
        data.put("location", domain.getLocation());

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return data;
    }


}
