package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: SearchNetworkJson.java 884 2013-08-08 14:52:53Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/SearchNetworkJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class SearchNetworkJson extends AbstractJsonAction {

    private static final long serialVersionUID = 4654758167246992232L;

    protected NetworkService networkService;
    
    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }
    
    protected String term;
    
    protected List<Network> networks;
    
    @Override
    public String execute() {
        //TODO david, 07/08/2013 add a parameter for the number of expecting result
        networks = networkService.getNameFiterNetwork(term, null);
        return SUCCESS;
    }
    
    @Override
    public Object getJsonData() {
        return networks;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public List<Network> getNetworks() {
        return networks;
    }

}
