package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesList.java 1048 2013-08-28 12:57:55Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class GenericEntitiesList extends AbstractAgrosystAction implements Preparable {

    private static final Log log = LogFactory.getLog(GenericEntitiesList.class);
    private static final long serialVersionUID = -2256628821672426679L;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    protected String genericClassName;

    protected List<String> properties;

    protected String entitiesJson;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    @Override
    public void prepare() throws Exception {

        try {
            Class<?> klass = Class.forName(genericClassName);
            properties = service.getProperties(klass);

            ResultList<?> entities = service.listEntities(klass, null);

            if (klass.isEnum()) {
                properties.add("Traduction");
                for (Object entity : entities) {
                    Map<String, String> entityMap = (Map<String, String>) entity;
                    String name = entityMap.get("Valeur");
                    String traduction = getText(klass.getName() + "." + name);
                    entityMap.put("Traduction", traduction);
                }
            }

            entitiesJson = getGson().toJson(entities);
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occured", e);
            }
            properties = Lists.newArrayList();
        }
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public String getEntitiesJson() {
        return entitiesJson;
    }

    public List<String> getProperties() {
        List<String> copy = Lists.newArrayList();
        if (properties != null) {
            copy.addAll(properties);
            copy.remove("active"); // active will be managed separately
        }
        return copy;
    }

    public int getPropertiesSize() {
        int result = 0;
        if (properties != null) {
            result = properties.size();
        }
        result++; // column active
        return result;
    }

    public boolean isReferential() {
        return genericClassName.startsWith("fr.inra.agrosyst.api.entities.referentiels.Ref");
    }

}
