package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Materiels.java 1039 2013-08-28 08:54:32Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/Materiels.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.Materiel;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.referentiels.RefMateriel;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.services.domain.ToolsCouplingDto;
import fr.inra.agrosyst.api.services.referentiels.MaterielType;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class Materiels {

    protected static final Function<Materiel, MaterielDto> MATERIEL_TO_DTO = new Function<Materiel, MaterielDto>() {
        @Override
        public MaterielDto apply(Materiel input) {
            MaterielDto dto = new MaterielDto();
            dto.setTopiaId(input.getTopiaId());
            dto.setName(input.getName());
            dto.setDescription(input.getDescription());
            dto.setMaterielETA(input.isMaterielETA());
            RefMateriel refMateriel = input.getRefMateriel();
            if (refMateriel != null) {
                if (refMateriel instanceof RefMaterielAutomoteur) {
                    dto.setMaterielType(MaterielType.AUTOMOTEUR);
                    dto.setPerformanceUnite(((RefMaterielAutomoteur) refMateriel).getPerformanceUnite());
                    dto.setPerformance(((RefMaterielAutomoteur) refMateriel).getPerformance());
                } else if (refMateriel instanceof RefMaterielIrrigation) {
                    dto.setMaterielType(MaterielType.IRRIGATION);
                } else if (refMateriel instanceof RefMaterielTraction) {
                    dto.setMaterielType(MaterielType.TRACTEUR);
                } else if (refMateriel instanceof RefMaterielOutil) {
                    dto.setMaterielType(MaterielType.OUTIL);
                    dto.setPerformanceUnite(((RefMaterielOutil) refMateriel).getPerformanceUnite());
                    dto.setPerformance(((RefMaterielOutil) refMateriel).getPerformance());
                }
                dto.setMaterielTopiaId(refMateriel.getTopiaId());
                dto.setTypeMateriel1(refMateriel.getTypeMateriel1());
                dto.setTypeMateriel2(refMateriel.getTypeMateriel2());
                dto.setTypeMateriel3(refMateriel.getTypeMateriel3());
                dto.setTypeMateriel4(refMateriel.getTypeMateriel4());
                dto.setUnite(refMateriel.getUnite());
                dto.setUniteParAn(refMateriel.getUniteParAn());
            } else {
                dto.setMaterielType(MaterielType.AUTRE);
            }
            return dto;
        }
    };

    protected static final Function<ToolsCoupling, ToolsCouplingDto> TOOLS_COUPLING_TO_DTO = new Function<ToolsCoupling, ToolsCouplingDto>() {

        @Override
        public ToolsCouplingDto apply(ToolsCoupling input) {
            ToolsCouplingDto dto = new ToolsCouplingDto();
            dto.setTopiaId(input.getTopiaId());
            dto.setTractorId(Entities.GET_TOPIA_ID.apply(input.getTractor()));
            List<Materiel> equipements = input.getCouplingEquipements();
            Set<String> equipementsIds = Sets.newHashSet(Iterables.transform(equipements, Entities.GET_TOPIA_ID));
            dto.setEquipementsIds(equipementsIds);
            dto.setComment(input.getComment());
            dto.setFlow(input.getFlow());
            dto.setInterventionName(input.getInterventionName());
            dto.setInterventionType(input.getInterventionType());
            dto.setWorkforce(input.getWorkforce());
            return dto;
        }

    };

}
