package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GpsDatas.java 766 2013-07-30 22:09:19Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/GpsDatas.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.base.Predicate;

import fr.inra.agrosyst.api.entities.GPSData;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class GpsDatas {

    public static final Predicate<GPSDataDto> IS_INVALID_GPS_DATA = new Predicate<GPSDataDto>() {
        @Override
        public boolean apply(GPSDataDto gpsDataDto) {
            return !gpsDataDto.isValid();
        }
    };

    public static final Function<GPSData, GPSDataDto> GPS_DATA_TO_DTO = new Function<GPSData, GPSDataDto>() {
        @Override
        public GPSDataDto apply(GPSData input) {
            GPSDataDto result = new GPSDataDto(
                    input.getTopiaId(),
                    input.getName(),
                    input.getLongitude(),
                    input.getLatitude(),
                    input.getDescription());
            return result;
        }
    };

}
