package fr.inra.agrosyst.web.actions.domains;

import java.util.Map;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;

import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GetRefLocationJson.java 920 2013-08-12 15:12:02Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/GetRefLocationJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


/**
 * Action d'afficher les information de localisation.
 * 
 * @author David Cossé
 */
public class GetRefLocationJson extends AbstractJsonAction {

    private static final long serialVersionUID = 1L;
    
//    private static final Log log = LogFactory.getLog(GetRefLocationJson.class);

    protected ReferentielService referentielService;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    protected String locationTopiaId;

    protected String departement;
    protected String departementName;
    protected String petiteRegionAgricole;
    protected String petiteRegionAgricoleName;
    protected int region;

    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }

    protected String orNC(String text) {
        String result = Objects.firstNonNull(text, "n/c");
        return result;
    }

    @Override
    public String execute() throws Exception {

        RefLocation refLocation = referentielService.getRefLocation(locationTopiaId);

        departement = refLocation.getDepartement();
        String key = "departement." + Strings.padStart(departement, 2, '0');
        departementName = getText(key, "n/c");
        petiteRegionAgricole = orNC(refLocation.getPetiteRegionAgricoleCode());
        petiteRegionAgricoleName = orNC(refLocation.getPetiteRegionAgricoleNom());
        region = refLocation.getRegion();

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        Map<String, String> result = ImmutableMap.of(
                "departement", departement,
                "departementName", departementName,
                "petiteRegionAgricole", petiteRegionAgricole,
                "petiteRegionAgricoleName", petiteRegionAgricoleName,
                "region", String.valueOf(region)
        );
        return result;
    }

}
