package fr.inra.agrosyst.web.actions.domains;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.GPSData;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GPSDataDto.java 340 2013-07-01 17:01:08Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/GPSDataDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/**
 * DTO de GPSData.
 * 
 * @author David Cossé
 */
public class GPSDataDto implements Comparable<GPSData>, Serializable {

    private static final long serialVersionUID = 197457017317376522L;

    protected String topiaId;

    protected String name;

    protected Double longitude;

    protected Double latitude;

    protected String description;

    public GPSDataDto() {
    }

    public GPSDataDto(String topiaId, String name, Double longitude,
                      Double latitude, String description) {
        this.topiaId = topiaId;
        this.name = name;
        this.longitude = longitude;
        this.latitude = latitude;
        this.description = description;
    }

    @Override
    public int compareTo(GPSData gpsData) {
        int result = 0;
        if ((StringUtils.equals(gpsData.getName(), name)
                && gpsData.getLatitude()==latitude
                && gpsData.getLongitude()==longitude
                && StringUtils.equals(gpsData.getDescription(), description))) {
            result = 0;
        } else {
            result = -1;
        }
        return result;
    }

    public boolean isEmpty() {
        boolean result =
                Strings.isNullOrEmpty(name)
                && Strings.isNullOrEmpty(description)
                && latitude == null
                && longitude == null;
        return result;
    }

    /**
     * 
     * @return vrai si tous les champs obligatoires sont remplis
     */
    public boolean isValid() {
        boolean result =
                !Strings.isNullOrEmpty(name)
                && latitude != null
                && longitude != null;
        return result;
    }

    public void setName(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.name = name;
        }
    }
    
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public Double getLongitude() {
        return longitude;
    }
    
    public Double getLatitude() {
        return latitude;
    }
    
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
