package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsList.java 820 2013-08-06 07:48:36Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Domain list action.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class DomainsList extends AbstractAgrosystAction {

    /**
     * UID
     */
    private static final long serialVersionUID = 1L;

    /** Domain result serialized as json. */
    protected String domainsResult;

    public String getDomainsResult() {
        return domainsResult;
    }

    protected DomainService domainService;
    
    protected AgrosystServiceConfig serviceConfig;
    
    protected ResultList<Domain> domainListResult;
    
    protected boolean extendable= false;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
    
    public void setAgrosystServiceConfig(AgrosystServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }
    
    protected AgrosystWebApplicationContext context;

    @Override
    public String execute() throws Exception {
        DomainFilter domainFilter = new DomainFilter();
        NavigationContext navigationContext = getNavigationContext();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setPageSize(getConfig().getListResultsPerPage());
        domainListResult = domainService.getFilteredDomains(domainFilter);
        domainsResult = getGson().toJson(domainListResult);
        return SUCCESS;
    }
    
    public Map<DomainType, String> getTypes() {
        return getEnumAsMap(DomainType.values());
    }
    
    public int getNbAuthorizedExtend() {
        int extendedMaxYear = serviceConfig.getExtendMaxYears();
        return extendedMaxYear;
    }

    public void setExtendable(boolean extendable) {
        this.extendable = extendable;
    }
    
}
