package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsExtend.java 1109 2013-09-02 16:27:32Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsExtend.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Prolongation d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsExtend extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected DomainService domainService;
    
    protected AgrosystServiceConfig serviceConfig;

    /** Au pluriel car interface communes avec la liste, ne pas modifier. */
    protected String domainIds;

    /** Campagne associée au nouveau domaine. */
    protected int extendCampaign;

    /** Duplicated domain. */
    protected Domain domain;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
    
    public void setAgrosystServiceConfig(AgrosystServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public void setDomainIds(String domainIds) {
        this.domainIds = domainIds;
    }

    public void setExtendCampaign(int extendCampaign) {
        this.extendCampaign = extendCampaign;
    }
    
    
    @Override
    @Action(results = {
            @Result(name = SUCCESS, type = "redirectAction", params = {"actionName", "domains-edit!input", "domainTopiaId", "${domain.topiaId}"}),
            @Result(name = ERROR, type = "redirectAction", params = {"actionName", "domains-list"})})
    public String execute() throws Exception {
        Domain domain = domainService.getDomain(this.domainIds);
        List<Domain> relatedDomains = domainService.getRelatedDomains(domain);
        Integer lastCampaign;
        if (relatedDomains != null && relatedDomains.size()>0){
            Domain lastDomain = relatedDomains.get(0);
            lastCampaign = lastDomain.getCampaign();
        } else {
            lastCampaign = domain.getCampaign();
        }
        
        int extendMaxYear = serviceConfig.getExtendMaxYears();
        int maxCampain = lastCampaign + extendMaxYear;
        
        if (extendCampaign > maxCampain) {//Extend campaign year valid
            notificationSupport.domainExtendError("Impossible d'étendre de domaine au delà de %d année après la dernière campagne", extendMaxYear);
            return ERROR;
        } else {
            this.domain = domainService.extendDomain(domainIds, extendCampaign);
        }
        return SUCCESS;
    }

    public Domain getDomain() {
        return domain;
    }
}
