package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunImport.java 1109 2013-09-02 16:27:32Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunImport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referentiels.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.entities.referentiels.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefOTEX;
import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referentiels.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.referentiels.ImportResult;
import fr.inra.agrosyst.api.services.referentiels.ImportService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RunImport extends AbstractAgrosystAction {

    private static final long serialVersionUID = 4130324772446717782L;

    protected ImportService importService;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    protected String genericClassName;
    protected Class<?> klass;

    protected File source1;
    protected File source2;
    protected File source3;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setSource1(File source1) {
        this.source1 = source1;
    }

    public void setSource2(File source2) {
        this.source2 = source2;
    }

    public void setSource3(File source3) {
        this.source3 = source3;
    }

    protected void required(File... sources) {
        if (sources != null) {
            int index = 0;
            for (File source : sources) {
                index++;
                if (source == null) {
                    addFieldError("source" + index, "Fichier manquant");
                }
            }
        }
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(genericClassName)) {
            addFieldError("genericClassName", "Ce champ est obligatoire");
        }

        try {
            klass = Class.forName(genericClassName);
        } catch (ClassNotFoundException e) {
            addFieldError("genericClassName", "Classe non trouvée");
        }

        if (RefSolArvalis.class.equals(klass)) {
            required(source1);
        }

        if (RefLocation.class.equals(klass)) {
            required(source1, source2, source3);
        }

        if (RefMaterielTraction.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielOutil.class.equals(klass)) {
            required(source1);
        }

        if (RefLegalStatus.class.equals(klass)) {
            required(source1);
        }

        if (RefEspece.class.equals(klass)) {
            required(source1);
        }

        if (RefVarieteGeves.class.equals(klass)) {
            required(source1);
        }

        if (RefVarietePlantGrape.class.equals(klass)) {
            required(source1);
        }

        if (RefClonePlantGrape.class.equals(klass)) {
            required(source1);
        }

        if (RefEspeceToVariete.class.equals(klass)) {
            required(source1);
        }

        super.validate();
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}"})})
    public String execute() throws Exception {

        ImportResult importResult = null;

        if (RefSolArvalis.class.equals(klass)) {
            importResult = importService.importSolArvalisCSV(
                    new FileInputStream(source1),
                    source2 == null ? null : new FileInputStream(source2));
        }

        if (RefLocation.class.equals(klass)) {
            importResult = importService.importCommuneInseeCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2),
                    new FileInputStream(source3));
        }

        if (RefMaterielTraction.class.equals(klass)) {
            importResult = importService.importMaterielTracteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            importResult = importService.importMaterielIrrigationCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            importResult = importService.importMaterielAutomoteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielOutil.class.equals(klass)) {
            importResult = importService.importMaterielOutilsCSV(
                    new FileInputStream(source1));
        }

        if (RefLegalStatus.class.equals(klass)) {
            importResult = importService.importLegalStatusCSV(
                    new FileInputStream(source1));
        }

        if (RefEspece.class.equals(klass)) {
            importResult = importService.importEspeces(
                    new FileInputStream(source1));
        }

        if (RefVarieteGeves.class.equals(klass)) {
            importResult = importService.importVarietesGeves(
                    new FileInputStream(source1));
        }

        if (RefEspeceToVariete.class.equals(klass)) {
            importResult = importService.importEspecesToVarietes(
                    new FileInputStream(source1));
        }
        
        if (RefOTEX.class.equals(klass)) {
            importResult = importService.importOtexCSV(
                    new FileInputStream(source1));
        }

        if (RefClonePlantGrape.class.equals(klass)) {
            importResult = importService.importClonesPlantGrape(
                    new FileInputStream(source1));
        }

        if (RefVarietePlantGrape.class.equals(klass)) {
            importResult = importService.importVarietesPlantGrape(
                    new FileInputStream(source1));
        }
        
        if (RefOrientationEDI.class.equals(klass)) {
            importResult = importService.importOrientationEdiCSV(
                    new FileInputStream(source1));
        }

        if (importResult != null) {
            if (importResult.hasErrors()) {
                for (String error : importResult.getErrors()) {
                    notificationSupport.importError("ÉCHEC : %s", error);
                }
            } else {
                notificationSupport.importSuccess("RÉUSSITE : Import terminé en %dms. %d créé(s) - %d modifié(s) - %d supprimé(s) - %d ignoré(s)",
                        importResult.getDuration(),
                        importResult.getCreated(),
                        importResult.getUpdated(),
                        importResult.getDeleted(),
                        importResult.getIgnored());
            }
        }
        return SUCCESS;
    }

}
