package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunExport.java 1059 2013-08-28 16:38:05Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunExport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referentiels.ImportService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RunExport extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(RunExport.class);

    private static final long serialVersionUID = -5821886179843474360L;

    protected ImportService importService;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    protected String genericClassName;
    protected List<String> entityIds;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "text/csv",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream;
        try {
            Class<?> klass = Class.forName(genericClassName);
            
            if (RefSolArvalis.class.equals(klass)) {
                inputStream = importService.exportSolArvalisCSV(entityIds);
            } else if (RefOrientationEDI.class.equals(klass)) {
                inputStream = importService.exportOrientationEdiCSV(entityIds);
            } else {
                inputStream = null;
            }
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate csv", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "generic-export.csv";
        return filename;
    }
}
