package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Home.java 1186 2013-09-06 14:46:40Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/Home.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.ActionType;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.InterventionType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.PollinatorType;
import fr.inra.agrosyst.api.entities.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.referentiels.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referentiels.RefEspece;
import fr.inra.agrosyst.api.entities.referentiels.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMateriel;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referentiels.RefVarietePlantGrape;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class Home extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = 6516792714690014172L;

    protected Map<String, Long> referentialClasses;

    protected Map<String, Long> autorityClasses;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    @Override
    public void prepare() throws Exception {
        referentialClasses = service.countEntities(
                RefLocation.class,
                RefSolArvalis.class,
                RefLegalStatus.class,
                RefMateriel.class,
                RefMaterielAutomoteur.class,
                RefMaterielIrrigation.class,
                RefMaterielTraction.class,
                RefMaterielOutil.class,
                RefEspece.class,
                RefVarieteGeves.class,
                RefVarietePlantGrape.class,
                RefClonePlantGrape.class,
                RefEspeceToVariete.class,
                RefOrientationEDI.class
        );

        autorityClasses = service.countEntities(
                DomainType.class,
                TypeDEPHY.class,
                Sector.class,
                PracticedSystemSource.class,
                WaterFlowDistance.class,
                Zoning.class,
                MaxSlope.class,
                InterventionType.class,
                OrchardFrutalForm.class,
                VineFrutalForm.class,
                PollinatorType.class,
                PollinatorSpreadMode.class,
                ActionType.class
        );

    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public Map<String, Long> getReferentialClasses() {
        return referentialClasses;
    }

    public Map<String, Long> getAutorityClasses() {
        return autorityClasses;
    }
}
