package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebSession.java 1109 2013-09-02 16:27:32Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebSession.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * Unique objet en session qui regroupe les données de session de l'utilisateur
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebSession {

    /**
     * Clé utilisée pour stocker l'instance de {@link AgrosystWebSession} dans la map de session HTTP.
     */
    public static final String SESSION_PARAMETER = "agrosystSession";

    protected NavigationContext navigationContext;

    protected UserDto authenticatedUser;

    protected Set<AgrosystWebNotification> infoNotifications = Sets.newHashSet();
    
    protected Set<AgrosystWebNotification> warningNotifications = Sets.newHashSet();
    
    protected Set<AgrosystWebNotification> errorNotifications = Sets.newHashSet();

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public UserDto getAuthenticatedUser() {
        return authenticatedUser;
    }

    public void setAuthenticatedUser(UserDto authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public Set<AgrosystWebNotification> getInfoNotifications() {
        return infoNotifications;
    }

    public Set<AgrosystWebNotification> getWarningNotifications() {
        return warningNotifications;
    }

    public Set<AgrosystWebNotification> getErrorNotifications() {
        return errorNotifications;
    }
}
