/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotificationSupport.java 1162 2013-09-05 15:05:27Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.4.1/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotificationSupport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.PracticedSystem;

public class AgrosystWebNotificationSupport {

    public AgrosystWebSession agrosystSession;

    public AgrosystWebNotificationSupport(AgrosystWebSession agrosystSession) {
        this.agrosystSession = agrosystSession;
    }

    public void domainCreated(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Domaine créé")
                .link("Voir le domaine", "/domains", "domains-edit!input", "domainTopiaId", domain.getTopiaId());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void domainUpdated(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Domaine mis à jour")
                .link("Voir le domaine", "/domains", "domains-edit!input", "domainTopiaId", domain.getTopiaId());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void domainExtendError(String message, int extendMaxYear) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, extendMaxYear);
        agrosystSession.getErrorNotifications().add(msg);
    }
    
    public void importError(String message, String error) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, error);
        agrosystSession.getErrorNotifications().add(msg);
    }

    public void importSuccess(String message, long duration, int created, int updated, int deleted, int ignored) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, duration, created, updated, deleted, ignored);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingPlanCreated(GrowingPlan growingPlan) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Dispositif créé")
                .link("Voir le dispositif", "/growingplans", "growing-plans-edit!input", "growingPlanTopiaId", growingPlan.getTopiaId());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingPlanUpdated(GrowingPlan growingPlan) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Dispositif mis à jour")
                .link("Voir le dispositif", "/growingplans", "growing-plans-edit!input", "growingPlanTopiaId", growingPlan.getTopiaId());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void practicedSystemSaved(PracticedSystem practicedSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(String.format("Système pratiqué '%s' enregistré", practicedSystem.getName()))
                .link("Voir le système pratiqué", "/practiced", "practiced-systems-edit!input", "practicedSystemTopiaId", practicedSystem.getTopiaId());
        agrosystSession.getInfoNotifications().add(msg);
    }

}
