package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersUnactivate.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Désactivation multiple d'utilisateurs.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class UsersUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 5338924873719324729L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected Set<String> userIds;

    public void setUserIds(Set<String> userIds) {
        this.userIds = userIds;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/security", "actionName", "users-list"})})
    public String execute() throws Exception {
        userService.unactivateUsers(userIds);
        return SUCCESS;
    }

}
