package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersListJson.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserFilter;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class UsersListJson extends AbstractJsonAction {

    private static final long serialVersionUID = 8714662434791990669L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected String filter;

    protected ResultList<UserDto> users;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        UserFilter usersFilter = getGson().fromJson(this.filter, UserFilter.class);

        users = userService.getFilteredUsers(usersFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return users;
    }

}
