package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: UsersEdit.java 636 2013-07-22 16:46:53Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/UsersEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.StringUtil;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class UsersEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -1105114314373713221L;

    protected UserService userService;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected String userTopiaId;

    protected UserDto user;
    protected boolean newUser;

    protected String password;
    protected String confirmPassword;

    public void setUserTopiaId(String userTopiaId) {
        this.userTopiaId = userTopiaId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @Override
    public void prepare() throws Exception {
        if (Strings.isNullOrEmpty(userTopiaId)) {
            user = new UserDto();
            newUser = true;
        } else {
            user = userService.getUser(userTopiaId);
            newUser = false;
        }
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

    @Override
    public void validate() {
        
        UserDto user = getUser();
        String email = user.getEmail();
        if (Strings.isNullOrEmpty(email)) {
            addFieldError("user.email", "Le champ 'Email' est obligatoire");
        } else if (!StringUtil.isEmail(email)){
            addFieldError("user.email", "L'adresse email n'est pas valide");
        }

        if (userService.isEmailInUse(email, userTopiaId)) {
            addFieldError("user.email", "Cette adresse email est déjà utilisée");
        }
        if (newUser) {
            if (Strings.isNullOrEmpty(password)) {
                addFieldError("password", "Le champ 'password' est obligatoire");
            }
            if (Strings.isNullOrEmpty(confirmPassword)) {
                addFieldError("confirmPassword", "Le champ 'confirmPassword' est obligatoire");
            }
        }
        if (!Objects.equal(password, confirmPassword)) {
            addFieldError("confirmPassword", "Les champs 'password' et 'confirmPassword' ne correspondent pas");
        }
        if (Strings.isNullOrEmpty((user.getFirstName()))) {
            addFieldError("user.firstName", "Le champ 'Prénom' est obligatoire");
        }
        if (Strings.isNullOrEmpty((user.getLastName()))) {
            addFieldError("user.lastName", "Le champ 'Nom' est obligatoire");
        }
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/security", "actionName", "users-list"})})
    public String execute() throws Exception {

        if (Strings.isNullOrEmpty(userTopiaId)) {
            userService.createUser(user, password);
        } else {
            userService.updateUser(user, password);
        }

        return SUCCESS;
    }

    public UserDto getUser() {
        if (user == null) {
            return new UserDto();
        }
        return user;
    }

    public boolean isNewUser() {
        return newUser;
    }

    public Map<Boolean, String> getTrueFalse() {
        Map<Boolean, String> result = ImmutableMap.of(Boolean.TRUE, "Oui", Boolean.FALSE, "Non");
        return result;
    }

}
