package fr.inra.agrosyst.web.actions.practicedsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsListJson.java 576 2013-07-19 07:47:27Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practicedsystems/PracticedSystemsListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.practicedSystem.PracticedSystemFilter;
import fr.inra.agrosyst.api.services.practicedSystem.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class PracticedSystemsListJson extends AbstractJsonAction {

    protected PracticedSystemService practicedSystemService;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    protected String filter;
    
    protected ResultList<PracticedSystem> practicedSystems;
    
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public String execute() {
        PracticedSystemFilter pracfilter = getGson().fromJson(filter, PracticedSystemFilter.class);
        NavigationContext navigationContext = getNavigationContext();
        pracfilter.setNavigationContext(navigationContext);
        practicedSystems = practicedSystemService.getFilteredPracticedSystems(pracfilter);

        return SUCCESS;
    }
    
    @Override
    public Object getJsonData() {
        return practicedSystems;
    }
}
