/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsEdit.java 600 2013-07-22 08:33:50Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practicedsystems/PracticedSystemsEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.practicedsystems;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.PracticedSystem;
import fr.inra.agrosyst.api.entities.PracticedSystemImpl;
import fr.inra.agrosyst.api.entities.PracticedSystemSource;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingSystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingSystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.practicedSystem.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PracticedSystemsEdit extends AbstractAgrosystAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5696853256365484417L;

    protected PracticedSystemService practicedSystemService;

    protected GrowingSystemService growingSystemService;

    protected String practicedSystemTopiaId;

    protected PracticedSystem practicedSystem;

    protected List<GrowingSystem> growingSystems;

    protected String growingSystemId;

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public PracticedSystem getPracticedSystem() {
        if (practicedSystem == null) {
            // EChatellier 27/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new PracticedSystemImpl();
        }
        return practicedSystem;
    }

    @Override
    public void prepare() throws Exception {
        if (StringUtils.isNotBlank(practicedSystemTopiaId)) {
            practicedSystem = practicedSystemService.getPracticedSystem(practicedSystemTopiaId);
        } else {
            practicedSystem = new PracticedSystemImpl();
        }
    }

    @Override
    public String input() throws Exception {
        // warning, practicedSystem's growingSystem must always be part of growingSystems set
        // even not selected be navigation context
        if (getPracticedSystem().getTopiaId() != null) {
            growingSystems = Collections.singletonList(getPracticedSystem().getGrowingSystem());
        } else {
            GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
            NavigationContext navigationContext = getNavigationContext();
            growingSystemFilter.setNavigationContext(navigationContext);
            growingSystemFilter.setPageSize(GrowingSystemFilter.ALL_PAGE_SIZE);
            ResultList<GrowingSystem> growingSystemListResult = growingSystemService.getFilteredGrowingSystems(growingSystemFilter);
            growingSystems = growingSystemListResult.getElements();
        }
        return INPUT;
    }

    @Action(results = { @Result(type = "redirectAction", params = {"actionName", "practiced-systems-list" }) })
    @Override
    public String execute() throws Exception {
        // can define domain only during create action
        if (StringUtils.isBlank(getPracticedSystem().getTopiaId())) {
            GrowingSystem growingSystem = growingSystemService.getGrowingSystem(growingSystemId);
            getPracticedSystem().setGrowingSystem(growingSystem);
        }
        practicedSystemService.updatePracticedSystem(practicedSystem);
        return SUCCESS;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

    public void setPracticedSystemTopiaId(String practicedSystemTopiaId) {
        this.practicedSystemTopiaId = practicedSystemTopiaId;
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public PracticedSystemSource[] getSources() {
        return PracticedSystemSource.values();
    }
}
