package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsUnactivate.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class PlotsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -2564747399236374335L;

    protected PlotService plotService;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    protected List<String> plotIds;
    
    public void setPlotIds(List<String> plotIds) {
        this.plotIds = plotIds;
    }
    
    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "plots-list" }) })
    public String execute() throws Exception {
        plotService.unactivatePlots(plotIds);
        return SUCCESS;
    }
}
