package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsList.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.plot.PlotFilter;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class PlotsList extends AbstractAgrosystAction {
    
    private static final long serialVersionUID = 3621646704704983917L;

    protected PlotService plotService;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    protected String plotsResult;
    
    @Override
    public String execute() throws Exception {
        NavigationContext navigationContext = getNavigationContext();
        PlotFilter filter = new PlotFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());
        
        ResultList<Plot> plotsResultList = plotService.getFilteredPlots(filter);
        plotsResult = getGson().toJson(plotsResultList);
        return SUCCESS;
    }

    public String getPlotsResult() {
        return plotsResult;
    }
}
