/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotsEdit.java 684 2013-07-23 15:57:08Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotsEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
package fr.inra.agrosyst.web.actions.plots;

import java.util.Collection;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.GrowingSystemImpl;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.PlotImpl;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingSystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class PlotsEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -1618279547328450777L;

    private static final String REQUIRED_FIELD = "Champ obligatoire";
    
    protected PlotService plotService;

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
    
    protected GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    protected String plotTopiaId;
    
    protected Plot plot;
    
    protected Set<Domain> domains;
    
    protected Set<GrowingSystem> growingSystems;
    
    protected GrowingSystem growingSystem;
    
    protected String growingSystemTopiaId;
    
    protected Domain domain;
    
    protected String locationTopiaId;
    
    protected String domainTopiaId;
    
    protected RefLocation location;
    
    protected String commune;
    
    protected String latitude;
    
    protected String longitude;
    
    
    /* (non-Javadoc)
     * @see com.opensymphony.xwork2.Preparable#prepare()
     */
    @Override
    public void prepare() throws Exception {

        if (StringUtils.isEmpty(plotTopiaId)){
            plot = plotService.newPlot();
        } else {
            plot = plotService.getPlot(plotTopiaId);
            
            domain = plot.getDomain();
            
            domainTopiaId = domain.getTopiaId();
            
            if (StringUtils.isBlank(locationTopiaId)) {
                // Cas ou la commune n'a pas étée modifiée
                locationTopiaId = plot.getLocation().getTopiaId();

                // Dans le cas ou il y a eu modification du choix de la commune
                location = domainService.getRefLocation(locationTopiaId);
            }
            
            growingSystem = plot.getGrowingSystem();
            
            if (growingSystem != null) {
                growingSystemTopiaId = growingSystem.getTopiaId();
            }
        }
        
        NavigationContext navigationContext = getNavigationContext();
        DomainFilter filter = new DomainFilter();
        filter.setActive(true);
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(DomainFilter.ALL_PAGE_SIZE);
        domains =  Sets.newLinkedHashSet(domainService.getFilteredDomains(filter));
        if (!domains.contains(domain)){
            domains.add(domain);
        };
    }
    
    @Override
    public String input() throws Exception {
        if (domain != null) {
            growingSystems = growingSystemService.findAllByDomain(domain);
        }
        return INPUT;
    }
    
    @Override
    public void validate() {
        // domain
        if (StringUtils.isBlank(domainTopiaId)) {
            addFieldError("domain-topiaId-choice", REQUIRED_FIELD);
        }
        // location
        if (StringUtils.isBlank(locationTopiaId)) {
            addFieldError("commune", REQUIRED_FIELD);
        }
        // name
        if (StringUtils.isBlank(plot.getName())) {
            addFieldError("name", REQUIRED_FIELD);
        }
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = { "actionName", "plots-list" }) })
    public String execute() throws Exception {
        if (!StringUtils.isBlank(latitude) && !StringUtils.isBlank(longitude)){
            plot.setLatitude(Double.parseDouble(latitude));
            plot.setLongitude(Double.parseDouble(longitude));
        }
        plot = plotService.updatePlot(plot, domainTopiaId, locationTopiaId, growingSystemTopiaId);
        return SUCCESS;
    }
    
    public Plot getPlot() {
        if (plot == null) {
            // AThimel 26/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new PlotImpl();
        }
        return plot;
    }
    
    public GrowingSystem getGrowingSystem() {
        if (growingSystem == null) {
            return new GrowingSystemImpl();
        }
        return growingSystem;
    }
    
    public String getGrowingSystemsJson() {
        String result="{}";
        if (growingSystems!=null) {
            result = getGson().toJson(growingSystems);
        }
        return result;
    }
    
    public String getDomainJson() {
        String result="{}";
        if (domain!=null) {
            result = getGson().toJson(domain);
        }
        return result;
    }
    
    public void setGrowingSystem(GrowingSystem growingSystem) {
        this.growingSystem = growingSystem;
    }

    public MaxSlope[] getMaxSlopes() {
        return MaxSlope.values();
    }
    
    public WaterFlowDistance[] getWaterFlowDistances() {
        return WaterFlowDistance.values();
    }
    
    public String getPlotTopiaId() {
        return plotTopiaId;
    }


    public void setPlotTopiaId(String plotTopiaId) {
        this.plotTopiaId = plotTopiaId;
    }


    public void setPlot(Plot plot) {
        this.plot = plot;
    }


    public Collection<Domain> getDomains() {
        return domains;
    }

    public String getDomainsJson() {
        return getGson().toJson(domains);
    }

    public String getCommune() {
        return commune;
    }


    public void setCommune(String commune) {
        this.commune = commune;
    }


    public void setLocationTopiaId(String locationTopiaId) {
        this.locationTopiaId = locationTopiaId;
    }
    
    
    public String getLocationTopiaId() {
        return locationTopiaId;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }


    public String getDomainTopiaId() {
        return domainTopiaId;
    }
    
    public String getLatitude() {
        return latitude;
    }


    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }


    public String getLongitude() {
        return longitude;
    }


    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public Set<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

    public String getGrowingSystemTopiaId() {
        return growingSystemTopiaId;
    }

    public void setGrowingSystemTopiaId(String growingSystemTopiaId) {
        this.growingSystemTopiaId = growingSystemTopiaId;
    }
    
 }
