package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotGrowingSystemsJson.java 576 2013-07-19 07:47:27Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotGrowingSystemsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;
import java.util.Set;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingSystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class PlotGrowingSystemsJson extends AbstractJsonAction {

    private static final long serialVersionUID = 760189523848814956L;

    protected DomainService domainService;
    
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
    protected GrowingSystemService growingSystemService;
    
    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }
    
    protected String domainTopiaId;
    
    protected Set<GrowingSystem> growingSystems;
    
    protected Map<String, String> growingSystemsRefs;
    
    @Override
    public String execute() throws Exception {
        Domain domain = domainService.getDomain(domainTopiaId);

        growingSystems = growingSystemService.findAllByDomain(domain);
        
        return SUCCESS;
    }
    
    @Override
    public Object getJsonData() {
        return growingSystems;
    }

    public void setDomainTopiaId(String domainTopiaId) {
        this.domainTopiaId = domainTopiaId;
    }

    
}
