package fr.inra.agrosyst.web.actions.plots;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PlotGrowingPlanPlotsJson.java 642 2013-07-22 20:44:59Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/plots/PlotGrowingPlanPlotsJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.services.growingPlan.GrowingPlanService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author cosse
 *
 */
public class PlotGrowingPlanPlotsJson extends AbstractJsonAction  {

    private static final long serialVersionUID = 7784391389093373240L;

    protected GrowingPlanService growingPlanService;
    
    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }
    
    protected PlotService plotService;
    
    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }
    
    protected List<Plot> plots;
    
    protected String growingPlanTopiaId;
    
    @Override
    public String execute() throws Exception {
        GrowingPlan growingPlan = growingPlanService.getGrowingPlan(growingPlanTopiaId);

        Domain domain = growingPlan.getDomain();
        plots = plotService.findAllByDomain(domain.getTopiaId());
        
        return SUCCESS;
    }
    
    @Override
    public Object getJsonData() {
        Map<String, Boolean> plotsIds = new HashMap<String, Boolean>();
        if (plots != null && !plots.isEmpty()) {
            for (Plot plot : plots) {
                String plotTopiaId = plot.getTopiaId();
                
                if (plot.getGrowingSystem() == null ){
                    plotsIds.put(plotTopiaId, false);
                } else {
                    plotsIds.put(plotTopiaId, true);
                }
            }
        }
        GrowingPlanPlots growingPlanPlots = new GrowingPlanPlots();
        growingPlanPlots.setPlots(plots);
        growingPlanPlots.setSelectedPlots(plotsIds);
        
        return growingPlanPlots;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

}
