package fr.inra.agrosyst.web.actions.growingsystems;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingSystemsUnactivate.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingsystems/GrowingSystemsUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.growingSystem.GrowingSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author cosse
 *
 */
public class GrowingSystemsUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 5109566144227877080L;

    protected GrowingSystemService growingSystemService;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    protected List<String> growingSystemIds;
    
    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }
    
    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "growing-systems-list" }) })
    public String execute() throws Exception {
        growingSystemService.unactivateGrowingSystems(growingSystemIds);
        return SUCCESS;
    }

}
