package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansUnactivate.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.growingPlan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Desactivation multiple de growingPlans.
 * 
 * @author Eric Chatellier
 */
public class GrowingPlansUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = -4930761732959095035L;

    protected GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    protected List<String> growingPlanIds;

    public void setGrowingPlanIds(List<String> growingPlanIds) {
        this.growingPlanIds = growingPlanIds;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "growing-plans-list" }) })
    public String execute() throws Exception {
        growingPlanService.unactivateGrowingPlans(growingPlanIds);
        return SUCCESS;
    }
}
